<?php

function _curl($url,$post = false,$headers = false,$json = false,$put = false,$cert=false,$timeout = 5) {    
    $CI     =& get_instance();  
    
    $CI->load->library('user_agent');
   // $hash   = sha1($url);
   
    //_log("CURL: ".$url);
    $ch = curl_init(); 
    //curl_setopt($ch, CURLOPT_HEADER, 0);  
    curl_setopt($ch,CURLOPT_USERAGENT,$CI->agent->browser().' '.$CI->agent->version());
    //curl_setopt($ch,CURLOPT_USERAGENT,"Opera/9.80 (J2ME/MIDP; Opera Mini/4.2.14912/870; U; id) Presto/2.4.15");
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
    curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,$timeout);    
    curl_setopt($ch,CURLOPT_TIMEOUT, $timeout); 
    curl_setopt($ch,CURLOPT_FOLLOWLOCATION,1);    
    curl_setopt($ch,CURLOPT_REFERER,base_url());  
    
    $headers[] = 'Accept-Language: en';
   // @curl_setopt($ch,CURLOPT_MAX_RECV_SPEED_LARGE,256000);  
    if($post)
    {
        $fields_string  = "";
        if(is_array($post))
        {
            foreach($post as $key => $value)
            {
                $fields_string .= $key."=".$value."&";
            }
            $fields_string          =rtrim ($fields_string,'&');
        }
        else
        {
            $fields_string          = $post;   
        }
        
        if($json)
        {
            $headers[]              = 'Accept: application/json';           
            $headers[]              = 'Content-Type: application/json';         
            
            $fields_string = json_encode($post);
        }
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch,CURLOPT_POST,count($post));
        curl_setopt($ch,CURLOPT_POSTFIELDS,$fields_string);
    }
    if(strtolower(parse_url($url, PHP_URL_SCHEME)) == 'https')
    {
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,0);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,0);
        if($cert)
        {            
            curl_setopt($ch, CURLOPT_CAINFO, $cert); 
        }
    }
    if($CI->config->item("proxy") != '')
    {       
        curl_setopt($ch, CURLOPT_PROXY, $CI->config->item("proxy"));
    }
     if($headers)
    {
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    }

    if($put)
    {
        if($put === true)
            $put = "PUT";
         curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $put);
        //curl_setopt($ch, CURLOPT_PUT, true);
    }

    curl_setopt($ch, CURLOPT_URL, $url); 
    $data = curl_exec($ch);
    curl_close($ch); 
     //_log("CURL END");
    return $data;
}


function ping($url)
{

    
    $CI     =& get_instance();  

    $headers[] = 'Accept-Language: en';
    
    $CI->load->library('user_agent');
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_NOBODY, true);
    curl_setopt($ch,CURLOPT_USERAGENT,$CI->agent->browser().' '.$CI->agent->version());
    curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,5);    
    curl_setopt($ch,CURLOPT_TIMEOUT, 8); 
    curl_setopt($ch,CURLOPT_FOLLOWLOCATION,1); 
    curl_setopt($ch,CURLOPT_REFERER,base_url());  
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");

    curl_exec($ch);
    $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($retcode == 404) 
        return false;
    return $retcode;
}


function _curl_headers($url)
{
       $CI     =& get_instance();  
    
    $CI->load->library('user_agent');
   $curl = curl_init();

    $opts = array (
            CURLOPT_URL => $url,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_ENCODING => 'gzip',
            CURLOPT_HEADER => true,
            CURLOPT_NOBODY => true,
            CURLOPT_COOKIESESSION, true,
            CURLOPT_USERAGENT => $CI->agent->browser().' '.$CI->agent->version()
    );

    curl_setopt_array($curl, $opts);
    $return = curl_exec($curl);
    list($rawHeader, $response) = explode("\r\n\r\n", $return, 2);
    $cutHeaders = explode("\r\n", $rawHeader);
    $headers = array();
    foreach ($cutHeaders as $row)
    {
        $cutRow = explode(":", $row, 2);
        $headers[$cutRow[0]] = trim($cutRow[1]);
    }

    return implode("<br>",$cutHeaders);
}

function is_logged()
{
  
    $CI     =& get_instance();
    
    if(intval($CI->session->userdata['user']['id'])>0)
        return true;
    return false;
}

function _user($field)
{
    $CI     =& get_instance();
    return $CI->session->userdata['user'][$field];
}

function __($code)
{
    $CI     =& get_instance();
    $translation = config_item('translation');
    

    $label = $translation[sha1(mb_strtolower($code))];    
    // Hack to save new labels
    if(get_cookie("lang") == 'en' && $label == '')
    {
        $CI->Admin->setTableIgnore("languages",array("name" => "English","code" => 'en'));
        $CI->Admin->setTableIgnore("translation",array("code" => sha1(mb_strtolower($code)),"translation" => $code,"code_lang" => 'en'));
    }
    if($label)
        return $label;
    return $code;
}

function get_email_admin()
{
    $CI     =& get_instance();
    $data = $CI->Admin->getTable("users",array("is_admin" => "1"));
    $temp = $data->row();
    return $temp->email;

}
function get_session($field)
{
     $CI     =& get_instance();
    return $CI->session->userdata[$field];
}
function is_admin()
{
   
    $CI     =& get_instance();    
    if(intval($CI->session->userdata['user']['is_admin'])>0)
        return true;
    return false;
}

function echo_json($json)
{
    $CI     =& get_instance();   
    echo $CI->output->set_content_type('application/json')->set_output(json_encode($json));
}
function is_sadmin()
{
   
    
    $CI     =& get_instance();    
    if(intval($CI->session->userdata['user']['is_admin'])>0)
        return true;
    return false;
}
function is_ajax()
{
    $CI     =& get_instance();   
    return $CI->input->is_ajax_request();
}
function is_mobile()
{
    $CI     =& get_instance();   
    return $CI->agent->is_mobile();
}
function getUserID()
{
    $CI     =& get_instance();
    return intval($CI->session->userdata['user']['id']);
}
function is_spotify()
{
    $CI     =& get_instance();    
    if($CI->session->userdata['user']['spotify']['access_token'])
        return true;
    return false;
}
function tdrows($elements)
{
    $str = "";
    foreach ($elements as $element) {
        $str .= $element->nodeValue . "||||";
    }

    return $str;
}

function getCountryCode()
{
   
    $CI     =& get_instance();  
    if($CI->session->geoplugin_countryCode)
        return $CI->session->geoplugin_countryCode;
    $ip         = $CI->input->ip_address();
    $url = "http://www.geoplugin.net/json.gp?ip=$ip";
    $data = json_decode(_curl($url));
    $code = $data->geoplugin_countryCode;
    if($code != '')
        $CI->session->set_userdata('geoplugin_countryCode', $code);
    if($code == '')
        $code = 'us';
    return $code;

}

function getLang()
{

    $lang = mb_strtolower(substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2));
    if($lang != '')
        return $lang;
    return config_item("default_lang");
}



function hex2rgba($color, $opacity = false) {
 
    $default = 'rgb(0,0,0)';
    
    //Return default if no color provided
    if(empty($color))
          return $default; 
 
    //Sanitize $color if "#" is provided 
        if ($color[0] == '#' ) {
            $color = substr( $color, 1 );
        }
 
        //Check if color has 6 or 3 characters and get values
        if (strlen($color) == 6) {
                $hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
        } elseif ( strlen( $color ) == 3 ) {
                $hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
        } else {
                return $default;
        }
 
        //Convert hexadec to rgb
        $rgb =  array_map('hexdec', $hex);
 
        //Check if opacity is set(rgba or rgb)
        if($opacity){
            if(abs($opacity) > 1)
                $opacity = 1.0;
            $output = 'rgba('.implode(",",$rgb).','.$opacity.')';
        } else {
            $output = 'rgb('.implode(",",$rgb).')';
        }
 
        //Return rgb(a) color string
        return $output;
}
function dslug($string)
{
    //$string = str_ireplace("-", "+", $string);
    //return urldecode($string);
    $string = urldecode($string);
    //$string = stripslashes($string);
    $string = addslashes($string);
    
    $string = str_ireplace("/", "-", $string);
    


    return $string;
}

function _ucwords($str)
{
    return mb_convert_case(mb_strtolower($str), MB_CASE_TITLE, "UTF-8");
}
function _strtolower($str)
{
    return mb_strtolower($str);
}

function _url_title($string,$remove=false)
{
    $string = mb_strtolower($string, 'UTF-8');    
    if($remove)
    {
        $string = str_ireplace("'", "",$string);
    }
    $string = str_ireplace("'", "%27",$string);
    $string = str_ireplace('"', "",$string);
    $string = str_ireplace('(', " ",$string);
    $string = str_ireplace(')', " ",$string);
    $string = str_ireplace(',', " ",$string);
    $string = str_ireplace(" ", "-",$string);
    $string = str_ireplace("--", "-",$string);
    $string = str_ireplace("--", "-",$string);
    $string = str_ireplace("--", "-",$string);
    $string = str_ireplace("--", "-",$string);
    $string = str_ireplace("+", "-",$string);
    $string = str_ireplace('&', "and",$string);
    $string = str_ireplace('*', "",$string);
    return $string;
}
function _remove_acents($string) {
    $acents= array ("á","é","í","ó","ú","Á","É","Í","Ó","Ú","ñ","À","Ã","Ì","Ò","Ù","Ã™","Ã ","Ã¨","Ã¬","Ã²","Ã¹","ç","Ç","Ã¢","ê","Ã®","Ã´","Ã»","Ã‚","ÃŠ","ÃŽ","Ã”","Ã›","ü","Ã¶","Ã–","Ã¯","Ã¤","«","Ò","Ã","Ã„","Ã‹");
    $l= array ("a","e","i","o","u","A","E","I","O","U","n","N","A","E","I","O","U","a","e","i","o","u","c","C","a","e","i","o","u","A","E","I","O","U","u","o","O","i","a","e","U","I","A","E");
    $string_ok = str_replace($acents, $l ,$string);
    return $string_ok;
}

function _clean_special($string) {
   

   return preg_replace('/[^a-zA-Z0-9ñÑ\s]/', '', _remove_acents($string));
}
function _clean_ip($string) {
   

   return preg_replace('/[^0-9.\s]/', '', $string);
}

function _clean_string($string)
{
    $string = str_ireplace("'", "",$string);
    $string = str_ireplace('"', " ",$string);                
    return $string;
}

function slug($string)
{    
    $string = normalize_name($string);
    return urlencode($string);
    return _url_title(convert_accented_characters($string));
}
function get_slug($slug)
{
    $CI     =& get_instance();     
    return $CI->config->item('slug_'.$slug);
}
function prepare($json)
{
    $json =  str_ireplace("</a","</span",str_ireplace("<a", "<span", $json));
    $json = str_ireplace("#text", "text", $json);
    return $json;
}
function mmss($seconds) {
  $t = round($seconds/1000);
  return sprintf('%02d:%02d', ($t/60%60), $t%60);
}
function _log($data)
{   
    $CI         =& get_instance(); 
    if($data == 'query' || $data=='db')
        $data = $CI->db->last_query();
    
    Console::log($data);
}


function _debug($msg)
{
    Console::log_memory();
    if(is_array($msg))
    {
        Console::log(date("H:i:s"));
        Console::log($msg);
    }
    else
        Console::log(date("H:i:s")." ".$msg);
}

function print_p($array)
{
    echo "<pre>";
    print_r($array);
    echo "</pre>";
}

function validate_picture($img)
{
    if($img == '')
    {
        $img = base_url()."assets/images/no-picture.png";
    }
    return $img;
}

function createFolder($folder)
{
    if(!file_exists($folder))
    {
        mkdir($folder);
    }
       
}
function return_bytes($val) {
    $val = trim($val);
    $last = strtolower($val[strlen($val)-1]);
    switch($last) {
        // The 'G' modifier is available since PHP 5.1.0
        case 'g':
            $val *= 1024;
        case 'm':
            $val *= 1024;
        case 'k':
            $val *= 1024;
    }

    return $val;
}

function uploadImage($folder,$file_name,$input)
{

       
        $CI     =& get_instance();          
        $config['upload_path']      = $folder;
        $config['allowed_types']    = 'jpg|jpeg|png';
        $config['max_size']         = return_bytes(ini_get('post_max_size'));              
        $config['overwrite']        = FALSE;             
        $config['file_name']        = $file_name;
        
        $CI->load->library('upload', $config);
        if ( ! $CI->upload->do_upload($input))
        {               
            $r =  strip_tags($CI->upload->display_errors());      
            return array('error' =>  $r);
        }
        else
        {
            
            $r = $CI->upload->data();     
            $config['image_library']    = 'gd2';
            $config['source_image']     = $config['upload_path']."/".$r['file_name'];
            $config['create_thumb']     = FALSE;
            $config['maintain_ratio']   = TRUE;
            $config['width']            = 600;
            $config['height']           = 600;            
            $CI->load->library('image_lib', $config);           
            if (!$CI->image_lib->resize())
            {
                    echo $CI->image_lib->display_errors();
                    die();
            }
            return array("image" => $r['file_name']);            
        }
}

function ago($time)
{
    
    $time = strtotime($time);
   $periods = array(__("second"), __("minute"), __("hour"), __("day"), __("week"), __("month"), __("year"), __("decade"));
   $lengths = array("60","60","24","7","4.35","12","10");

   $now = time();

       $difference     = $now - $time;
       $tense         = "ago";

   for($j = 0; $difference >= $lengths[$j] && $j < count($lengths)-1; $j++) {
       $difference /= $lengths[$j];
   }

   $difference = round($difference);

   if($difference != 1) {
       $periods[$j].= "s";
   }

   return "$difference ".__($periods[$j]);
}

function normalizer($cadena){
        $originales = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿŔŕ';
        $modificadas = 'aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyybyRr';
        $cadena = utf8_decode($cadena);
        $cadena = strtr($cadena, utf8_decode($originales), $modificadas);
        $cadena = strtolower($cadena);
        $cadena = str_ireplace("-", " ", $cadena);        
        $cadena = ltrim($cadena);
        $cadena = rtrim($cadena);
        return utf8_encode($cadena);
}

function get_header_curl($url)
{

    $ch = curl_init($url); 
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT ,3); 
    curl_setopt($ch, CURLOPT_TIMEOUT, 3); //timeout in seconds
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_HEADER,true);

    //curl_setopt($ch, CURLOPT_NOBODY, true);    
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);     
    curl_setopt($ch, CURLOPT_USERAGENT,'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');

    curl_exec($ch);     

    return curl_getinfo($ch, CURLINFO_CONTENT_TYPE);                
}


function remote_file_exists($url)
{
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_NOBODY, true);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT ,3); 
    curl_setopt($ch, CURLOPT_TIMEOUT, 3); //timeout in seconds
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
    curl_exec($ch);
    $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);   
    
    curl_close($ch);
    if($retcode > 400)
        return 0;
    return 1;
}
function isok($code)
{
    

    if(!$code)
        return array("error" => "Key Empty");
  

    $license = json_decode(_curl("http://key.nexxuz.com?key=$code"));    
    if(!$license->date)
        return array("error" => "Key No valid");      
     $return['created_at']      = $license->date;
     $return['product_name']    = "Nexxuz: Cloud Music Engine";
     $return['license']         = $license->type." <i>(IP Address Authorized: ".$license->ipserver.")</i>";
     $return['buyer']           = $license->buyer;      
    return $return;
}


function more($string,$len=100)
{    
    if(mb_strlen($string)<$len)
        return $string;
    return ltrim(substr(strip_tags($string), 0,$len))."...";
}
function br2nl($string)
{
    return preg_replace('/\<br(\s*)?\/?\>/i', "\n", $string);
}  

function email($to,$subject,$message)
{   

        $CI         =& get_instance();  
        //$CI->email->clear();
        $message = $CI->load->view("emails/template",array("message" => $message),TRUE);
        $CI->email->set_newline("\r\n");
        $CI->email->to($to);
        $CI->email->from(config_item("smtp_from"),config_item("site_title"));
        $CI->email->subject($subject);
        $CI->email->message($message);
        return $CI->email->send();

}

function normalize_name($str)
{
    $str = str_replace("&","And", $str);
    $remove = array("/","+","?","&","[","]");
    $str = str_replace($remove, " ",$str);
    return $str;
}
function set_https_url($url,$force = true)
{
    if($force)
        return str_ireplace("http://", "https://",$url);
    return $url;
}

function getDaysDiff($date_start,$date_end)
{
    $days   = (strtotime($date_start)-strtotime($date_end))/86400;
    $days   = abs($days); $days = floor($days);     
    return $days;
}
function is_valid_domain_name($url)
{

    return filter_var($url, FILTER_VALIDATE_URL, FILTER_FLAG_HOST_REQUIRED) && (preg_match("#^http(s)?://[a-z0-9-_.]+\.[a-z]{2,4}#i", $url));
}

function getStringBetween($string,$start,$end) {
    
    $string = " " . $string;
    
    $ini = strpos($string, $start);
    
    if ($ini == 0) return "";
    
    $ini+= strlen($start);
    
    $len = strpos($string, $end, $ini) - $ini;
    
    return substr($string, $ini, $len);
    
}
function connect($host, $port, $timeOut = 2) {
    $fp = fsockopen($host, $port, $errno, $errstr, $timeOut);
    if ($fp) {        
        fclose($fp); // we know it's listening        
        return true;
    } else {
        fclose($fp); // we know it's listening        
        return false;
    }
}
function getMeta($html,$tag)
{
    $meta = array();
    $doc = new DOMDocument();
    
    @$doc->loadHTML($html);
    
    $nodes = $doc->getElementsByTagName('title');    
    $meta['title'] = $nodes->item(0)->nodeValue;
    if(!$meta['title'])
    {
        $nodes = $doc->getElementsByTagName('TITLE');    
        $meta['title'] = $nodes->item(0)->nodeValue;

    }
    if(!$meta['title'])
    {
        $nodes = $doc->getElementsByTagName('Title');    
        $meta['title'] = $nodes->item(0)->nodeValue;

    }
    $metas = $doc->getElementsByTagName('meta');

    for ($i = 0; $i < $metas->length; $i++) {
    
        $metaTags = $metas->item($i);
        
        if(mb_strtolower($metaTags->getAttribute('name')) == 'description')
            $meta['description'] = $metaTags->getAttribute('content');
            
        if(mb_strtolower($metaTags->getAttribute('name')) == 'keywords')
            $meta['keywords'] = $metaTags->getAttribute('content');
    
    }
    
    return $meta[$tag];
}
function getTitle($html)
{
    preg_match("/<title>(.*)</title>/", $html, $title);
    if(count($title)) {
        return $title[1];
    } else {
        return false;
    }
}

function getDescription($html) {    
    $matches = array();    
    preg_match('/<meta.*?name=("|\')description("|\').*?content=("|\')(.*?)("|\')/i', $html, $matches);
    if (count($matches) > 4) {
        return trim($matches[4]);
    }    
    preg_match('/<meta.*?content=("|\')(.*?)("|\').*?name=("|\')description("|\')/i', $html, $matches);
    if (count($matches) > 2) {
        return trim($matches[2]);
    }    
    return null;
}

function colorCircle($val1,$val2)
{
    if($val1>$val2)
        return "#0ACC00";
    return "#F0AD4E";
}

function getIcon($val1,$val2)
{
    if($val1>$val2)
        return "zmdi-check";
    return "zmdi-alert-triangle";
}
function getColor($val1,$val2)
{
    if($val1>$val2)
        return "text-success";
    return "text-warning";
}

function getColorProgress($val1,$val2)
{
    if($val1>$val2)
        return "progress-success";
    return "progress-warning";
}


function validateLenght($str,$limit,$min =false)
{
    

    $response['color']  = "text-success";
    $response['icon']   = "zmdi-check";
    $response['fixed']  = $str;
    $response['lenght'] = mb_strlen($str);
    $response['fixed2'] = mb_substr($str, 0,$limit);

    if(mb_strlen($str)>$limit)
    {        
        $response['color']  = "text-warning";
        $response['icon']   = "zmdi-alert-triangle";
        $response['fixed']   = mb_substr($str, 0,$limit)."<span class='text-danger text-underline'>".mb_substr($str, $limit,mb_strlen($str))."</span>";
    }

    if($min)
    {

        if(mb_strlen($str)<$min)
        {        
            $response['color']  = "text-warning";
            $response['icon']   = "zmdi-alert-triangle";
            $response['fixed']   = mb_substr($str, 0,$limit)."<span class='text-danger text-underline'>".mb_substr($str, $limit,mb_strlen($str))."</span>";
        }

    }
    if(trim($str) =='')
    {        
        $response['fixed'] = "<div class='alert alert-warning'>".__("NO DATA")."</div>";
        $response['fixed2'] = "";
    }

    $response['fixed'] = badWords($response['fixed']);
    $response['fixed2'] = badWords($response['fixed2']);
    return $response;

}

function getPor($val,$total)
{
    return intval(($val*100)/$total);
}
function sanitize_output($buffer) {

    $search = array(
        '/\>[^\S ]+/s',  // strip whitespaces after tags, except space
        '/[^\S ]+\</s',  // strip whitespaces before tags, except space
        '/(\s)+/s'       // shorten multiple whitespace sequences
    );

    $replace = array(
        '> ',
        ' <',
        '\\1'
    );

    $buffer = preg_replace($search, $replace, $buffer);

    return $buffer;
}

function getAllLinks($html,$domain,$limit=15)
{
    $doc = new DOMDocument();
    $doc->loadHTML($html);
    $elements = $doc->getElementsByTagName("a");
    $x=0;
    $exist = array();
    foreach($elements as $el) {                        
        $l = $el->getAttribute("href");
        $l = fixLink($l);
        if(!isExternal($l,$domain) AND $l != '' AND strpos($l, "mailto:") === FALSE AND strpos($l, "tel:") === FALSE  AND strpos($l, "javascript:") === FALSE   AND strpos($l, "#") === FALSE &&  !$exist[$l])
        {
            
            $exist[$l] = 1;          
            
            if(mb_substr($l, 0,1) != '/' && strpos($l, "http") === FALSE)
                $l="/".$l;

           

            if(strpos($l, $domain) === FALSE)
                $l = $domain.$l;

             if(substr($l, 0,4) != 'http')
            {
                if(substr($l, 0,2) != '//')
                    $l = "://".$l;
                $l = "http".$l;
            }

            $link[] = $l;        
            $x++;
            if($x>=$limit)
                break;    
        }
        
        
    }
    return $link;
}

function fixLink($link)
{
    if( substr($link, 0,2) == '//')
        return "http:".$link;
    return $link;
}
function isExternal($link,$domain)
{
    

    if(strpos($link, "http") !== FALSE)
    {
        if(strpos($link, $domain) !== FALSE)
            return false;
        return true;
    }
    return false;
}

function badWords($str)
{

    $badWords = explode(",",_remove_acents(config_item("bad_words")));
    return str_ireplace($badWords, "---",_remove_acents($str));
}

function hasbadWords($str)
{
    $badWords = explode(",",config_item("bad_words"));
    foreach ($badWords as $key => $value) {
        if(mb_strpos($str, $value) !== FALSE)
            return true;
    }
    return false;
}



function base_url_lang()
{
    $CI     =& get_instance();  
    return base_url().$CI->lang."/";
}

function shortcode($content) {

    
    $pattern = '/\[(.*?)\]/';
    $regex = '/(\w+)\s*=\s*"(.*?)"/';
    $shorcode = array();

    preg_match_all($pattern, $content, $matches);   

    foreach ($matches[1] as $key => $value) {

        preg_match_all($regex, $value, $matches2);                  
        foreach ($matches2[1] as $key2 => $value2) {

            $shorcode[$key][$value2] = $matches2[2][$key2];
        }
        if($shorcode[$key]['type'])
            $shorcode[$key]['shortcode'] = $matches[0][$key];
        
    }
    return $shorcode;
}

function extractKeyWords($string) {
  

    $string = html_entity_decode($string);
  
    $string = preg_replace('#<script(.*?)>(.*?)</script>#is', '', $string);
    $string = str_ireplace("\n", " ", $string);
    preg_match("/<body[^>]*>(.*?)<\/body>/is", $string, $matches);
    $string = strip_tags($matches[0]);

  $stopWords = array();

  $string = preg_replace('/[\pP]/u', ' ', trim(preg_replace('/\s\s+/iu', ' ', mb_strtolower($string))));
  
  $matchWords = array_filter(explode(' ',$string) , function ($item) use ($stopwords) { return !($item == '' || in_array($item, $stopwords) || mb_strlen($item) <= 3 || is_numeric($item));});
  $wordCountArr = array_count_values($matchWords);  
  arsort($wordCountArr);
  return (array_slice($wordCountArr, 0, 10));
}
function processKeyWords($array)
{
    
    $total = 0;
    foreach ($array as $key => $value) {
        $total = $total + $value;
    }

    foreach ($array as $key => $value) {
        $array[$key] = round(($value*100)/$total);
    }
    return $array;
}
function rip_tags($string) { 
    
    // ----- remove HTML TAGs ----- 
    $string = preg_replace ('/<[^>]*>/', ' ', $string); 
    
    // ----- remove control characters ----- 
    $string = str_replace("\r", '', $string);    // --- replace with empty space
    $string = str_replace("\n", ' ', $string);   // --- replace with space
    $string = str_replace("\t", ' ', $string);   // --- replace with space
    
    // ----- remove multiple spaces ----- 
    $string = trim(preg_replace('/ {2,}/', ' ', $string));
    
    return $string; 

}
function getTextBetweenTags($string, $tagname){
    $d = new DOMDocument();
    $d->loadHTML($string);
    $return = array();
    foreach($d->getElementsByTagName($tagname) as $item){
        $return[] = $item->textContent;
    }
    return $return;
}

function getIPInfo($ip)
{
    
    return json_decode(_curl("http://ip-api.com/json/$ip"));
}
